<?php
/**
 * Template part for displaying default posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Abclogic
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class('post-default'); ?>>

	<header class="entry-header">
		<h3 class="entry-title"><?php 
			abclogic_sticky_label();
			the_title( '<a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a>' );
		?></h3>
		<div class="entry-meta">
			<?php
				abclogic_posted_by();
				abclogic_posted_in( array(
					'prefix' => __( 'In', 'abclogic' ),
				) );
				abclogic_posted_on( array(
					'prefix' => __( 'Posted', 'abclogic' )
				) );
			?>
		</div><!-- .entry-meta -->
	</header><!-- .entry-header -->

	<?php abclogic_post_thumbnail( 'abclogic-thumb-l' ); ?>

	<?php abclogic_post_excerpt(); ?>

	<footer class="entry-footer">
		<div class="entry-meta">
			<?php
				abclogic_post_tags( array(
					'prefix' => __( 'Tags:', 'abclogic' )
				) );
			?>
			<div><?php
				abclogic_post_comments( array(
					'prefix' => '<i class="fa fa-comment" aria-hidden="true"></i>',
					'class'  => 'comments-button'
				) );
				abclogic_post_link();
			?></div>
		</div>
		<?php abclogic_edit_link(); ?>
	</footer><!-- .entry-footer -->
	
</article><!-- #post-<?php the_ID(); ?> -->
