<?php
/**
 * Template part for top panel in header.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Abclogic
 */

// Don't show top panel if all elements are disabled.
if ( ! abclogic_is_top_panel_visible() ) {
	return;
} ?>

<div class="top-panel container">
	<div class="space-between-content">
		<div class="top-panel-content__left">
				<?php do_action( 'abclogic-theme/top-panel/elements-left' ); ?>
				<?php abclogic_site_description(); ?>
		</div>
		<div class="top-panel-content__right">
				<?php abclogic_social_list( 'header' ); ?>
				<?php do_action( 'abclogic-theme/top-panel/elements-right' ); ?>
		</div>
	</div>
</div>